/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.soo.dtoc;

import com.ibm.hwmca.fw.soo.dtoc.master;
import java.io.IOException;
import java.io.OutputStream;

final class sender
implements Runnable {
    private final String copyright = "(c) Copyright IBM Corp.  1997, 1998.  All rights reserved.";
    private OutputStream os;
    private volatile Thread runner;
    private byte[] buffer = new byte[4096];
    private int head;
    private int tail;
    private boolean fWait;
    private boolean fValid = false;
    private byte[] special = new byte[2];
    private byte[] control = new byte[1];
    private byte[] input = new byte[4];
    private master m;
    private static final String TRACE_MASKT = "XDTCSNDT";
    private static final String TRACE_MASKF = "XDTCSNDF";
    private static final String TRACE_MASKD = "XDTCSNDD";
    public static final byte SE_INIT_MAJOR = 2;
    public static final byte SE_INIT_MINOR = 80;
    public static final byte SE_INIT_HMC_MAJOR = 2;
    public static final byte SE_INIT_HMC_MINOR = 96;
    public static final byte SE_TERMINATE = 1;
    public static final byte SE_WATCHDOGTIMER = 15;
    public static final byte CE_DEBUGOUT = 6;
    public static final byte CE_CONTROL = 7;
    public static final byte KE_PRESS = 8;
    public static final byte KE_RELEASE = 9;
    public static final byte ME_DOWN1 = 2;
    public static final byte ME_UP1 = 3;
    public static final byte ME_DOWN2 = 10;
    public static final byte ME_UP2 = 11;
    public static final byte ME_DOWN3 = 12;
    public static final byte ME_UP3 = 13;
    public static final byte MME_MOVE = 4;
    public static final byte MME_DRAG = 5;

    public sender(master m) {
        this.m = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void initialize(OutputStream os, int environment) {
        this.m.trace(2, TRACE_MASKT, "-> initialize");
        if (this.runner == null) {
            this.os = os;
            this.tail = 0;
            this.head = 0;
            this.fWait = false;
            this.fValid = true;
            this.runner = new Thread(this);
            this.runner.start();
            byte[] byArray = this.special;
            // MONITORENTER : this.special
            if (environment == 1) {
                this.special[0] = 2;
                this.special[1] = 96;
            } else {
                this.special[0] = 2;
                this.special[1] = 80;
            }
            this.writeBytes(this.special, 0, 2);
            // MONITOREXIT : byArray
        }
        this.m.trace(2, TRACE_MASKT, "<- initialize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void terminate() {
        this.m.trace(2, TRACE_MASKT, "-> terminate");
        if (this.runner != null) {
            this.sendSpecialEvent((byte)1, (byte)0);
            this.runner = null;
            this.fValid = false;
            byte[] byArray = this.buffer;
            // MONITORENTER : this.buffer
            this.buffer.notify();
            // MONITOREXIT : byArray
        }
        this.m.trace(2, TRACE_MASKT, "<- terminate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        this.m.trace(2, TRACE_MASKT, "-> run");
        try {
            while (this.runner != null && this.fValid) {
                int index;
                block13: {
                    byte[] byArray = this.buffer;
                    // MONITORENTER : this.buffer
                    while (true) {
                        if (!this.fValid || this.tail != this.head) {
                            index = this.tail;
                            // MONITOREXIT : byArray
                            if (index <= this.head) break;
                            this.writeBytes(this.buffer, this.head, index - this.head);
                            break block13;
                        }
                        this.fWait = true;
                        this.buffer.wait();
                    }
                    if (index >= this.head) continue;
                    this.writeBytes(this.buffer, this.head, this.buffer.length - this.head);
                    if (index != 0) {
                        this.writeBytes(this.buffer, 0, index);
                    }
                }
                byte[] byArray = this.buffer;
                // MONITORENTER : this.buffer
                this.head = index;
                // MONITOREXIT : byArray
            }
        }
        catch (InterruptedException e) {
            this.m.trace(2, TRACE_MASKT, "Caught InterruptedException; leaving while loop");
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.os = null;
        this.fValid = false;
        this.m.trace(2, TRACE_MASKT, "<- run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void putBytes(byte[] buf, int len) {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int index = this.head;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (this.tail >= index) {
                int rest = this.buffer.length - this.tail;
                if (len >= rest + index) {
                    return;
                }
                if (len <= rest) {
                    System.arraycopy(buf, 0, this.buffer, this.tail, len);
                } else {
                    System.arraycopy(buf, 0, this.buffer, this.tail, rest);
                    System.arraycopy(buf, rest, this.buffer, 0, len - rest);
                }
            } else {
                if (len >= index - this.tail) {
                    return;
                }
                System.arraycopy(buf, 0, this.buffer, this.tail, len);
            }
            byte[] byArray2 = this.buffer;
            synchronized (this.buffer) {
                this.tail = (this.tail + len) % this.buffer.length;
                if (this.fWait) {
                    this.fWait = false;
                    this.buffer.notify();
                }
                // ** MonitorExit[var5_7] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBytes(byte[] buf, int offset, int len) {
        try {
            OutputStream outputStream = this.os;
            synchronized (outputStream) {
                this.os.write(buf, offset, len);
                this.os.flush();
            }
        }
        catch (IOException e) {
            this.m.trace(2, TRACE_MASKF, "IOException in writeBytes(): " + e.getMessage());
            this.fValid = false;
        }
    }

    public boolean isValid() {
        return this.fValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSpecialEvent(byte type, byte data) {
        byte[] byArray = this.special;
        synchronized (this.special) {
            this.special[0] = (byte)(type | data << 4);
            this.writeBytes(this.special, 0, 1);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void watchDogTimer() {
        this.sendSpecialEvent((byte)15, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendControlEvent(byte type, byte data) {
        byte[] byArray = this.control;
        synchronized (this.control) {
            this.control[0] = (byte)(type | data << 4);
            this.putBytes(this.control, 1);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void control(byte data) {
        this.sendControlEvent((byte)7, data);
    }

    public void debugOut(byte data) {
        this.sendControlEvent((byte)6, data);
    }

    public void sendKeyEvent(byte type, byte key, byte modifier) {
        this.input[0] = (byte)(type | modifier << 4);
        this.input[1] = (byte)(key & 0x7F);
        this.putBytes(this.input, 2);
    }

    public void keyPress(byte key, byte modifier) {
        this.sendKeyEvent((byte)8, key, modifier);
    }

    public void keyRelease(byte key, byte modifier) {
        this.sendKeyEvent((byte)9, key, modifier);
    }

    public void sendMouseEvent(byte type, byte modifier) {
        this.input[0] = (byte)(type | modifier << 4);
        this.putBytes(this.input, 1);
    }

    public void mouseDown1(byte modifier) {
        this.sendMouseEvent((byte)2, modifier);
    }

    public void mouseUp1(byte modifier) {
        this.sendMouseEvent((byte)3, modifier);
    }

    public void mouseDown2(byte modifier) {
        this.sendMouseEvent((byte)10, modifier);
    }

    public void mouseUp2(byte modifier) {
        this.sendMouseEvent((byte)11, modifier);
    }

    public void mouseDown3(byte modifier) {
        this.sendMouseEvent((byte)12, modifier);
    }

    public void mouseUp3(byte modifier) {
        this.sendMouseEvent((byte)13, modifier);
    }

    public void sendMouseMotionEvent(byte type, short x, short y) {
        this.input[0] = type;
        this.input[1] = (byte)(x & 0xFF);
        this.input[2] = (byte)(y & 0xFF);
        this.input[3] = (byte)((x & 0xF00) >> 8 | (y & 0xF00) >> 4);
        this.putBytes(this.input, 4);
    }

    public void mouseMove(short x, short y) {
        this.sendMouseMotionEvent((byte)4, x, y);
    }

    public void mouseDrag(short x, short y) {
        this.sendMouseMotionEvent((byte)5, x, y);
    }

    public void mouseEnter() {
    }

    public void mouseExit() {
    }
}

